<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\Model;

class ContractSetting extends Model 
{

    protected $table = 'contract_settings';
    public $timestamps = true;
    protected $fillable = array('contract_id', 'name', 'primary', 'begin_date', 'end_date', 'night_hours_begin', 'night_hours_end', 'eh_percent_between_0_2', 'eh_percent_between_2_3', 'eh_percent_between_3_4', 'eh_percent_between_4_5', 'eh_percent_more_5', 'eh_percent_restday', 'limit_hours_day', 'limit_hours_week', 'work_shift', 'limit_work_hours_day_in_work_shift', 'limit_work_hours_week_in_work_shift', 'rest_after_work_in_shift');
    protected $visible = array('name', 'primary', 'begin_date', 'end_date', 'night_hours_begin', 'night_hours_end', 'eh_percent_between_0_2', 'eh_percent_between_2_3', 'eh_percent_between_3_4', 'eh_percent_between_4_5', 'eh_percent_more_5', 'eh_percent_restday', 'limit_hours_week', 'work_shift', 'limit_work_hours_day_in_work_shift', 'limit_work_hours_week_in_work_shift', 'rest_after_work_in_shift');

    public function contract()
    {
        return $this->belongsTo('EmployeeContract', 'contract_id', 'id');
    }

}